<?php

namespace App\Models;

use CodeIgniter\Model;

class UsuarioModel extends Model
{
    protected $table = 'usuarios';
    protected $primaryKey = 'id_usuario';
    
    // ✅ CAMPOS PERMITIDOS - Incluye token, telefono y especialidad
    protected $allowedFields = [
        'username', 
        'email', 
        'password', 
        'tipo_usuario', 
        'estado',
        'token',          // ✅ AGREGADO
        'telefono',       // ✅ AGREGADO
        'especialidad'    // ✅ AGREGADO
    ];
    
    protected $useTimestamps = false;
    
    protected $beforeInsert = ['hashPassword'];
    protected $beforeUpdate = ['hashPasswordOnUpdate'];  // ✅ CAMBIADO
    
    /**
     * Hash password antes de insertar
     */
    protected function hashPassword(array $data)
    {
        if (isset($data['data']['password'])) {
            $data['data']['password'] = password_hash($data['data']['password'], PASSWORD_DEFAULT);
        }
        return $data;
    }
    
    /**
     * Hash password solo si se está actualizando la contraseña
     */
    protected function hashPasswordOnUpdate(array $data)
    {
        // ✅ Solo hashear si se está actualizando el password
        if (isset($data['data']['password']) && !empty($data['data']['password'])) {
            // Verificar si ya está hasheado (empieza con $2y$ o $2a$)
            if (!preg_match('/^\$2[ayb]\$.{56}$/', $data['data']['password'])) {
                $data['data']['password'] = password_hash($data['data']['password'], PASSWORD_DEFAULT);
            }
        }
        return $data;
    }
    
    /**
     * Verificar credenciales de login
     */
    public function verificarCredenciales($username, $password)
    {
        $usuario = $this->where('username', $username)
                         ->orWhere('email', $username)
                         ->first();
        
        if ($usuario && password_verify($password, $usuario['password'])) {
            // ✅ NO quitar el password aquí, lo haremos en el controller
            return $usuario;
        }
        
        return null;
    }
}
