<?php

namespace App\Filters;

use CodeIgniter\Filters\FilterInterface;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;

class AuthFilter implements FilterInterface
{
    public function before(RequestInterface $request, $arguments = null)
    {
        // Obtener el header Authorization
        $authHeader = $request->getHeaderLine('Authorization');
        
        log_message('debug', '🔍 AuthFilter - Header Authorization: ' . $authHeader);

        if (empty($authHeader)) {
            log_message('error', '❌ AuthFilter - No se encontró header Authorization');
            return service('response')
                ->setJSON([
                    'success' => false,
                    'message' => 'Token no proporcionado',
                    'data' => null
                ])
                ->setStatusCode(401);
        }

        // Extraer el token (remover "Bearer ")
        $token = str_replace('Bearer ', '', $authHeader);
        log_message('debug', '🔑 AuthFilter - Token extraído: ' . $token);

        // Validar el token en la base de datos
        $db = \Config\Database::connect();
        $builder = $db->table('usuarios');
        
        $usuario = $builder->where('token', $token)->get()->getRowArray();

        if (empty($usuario)) {
            log_message('error', '❌ AuthFilter - Token no válido: ' . $token);
            return service('response')
                ->setJSON([
                    'success' => false,
                    'message' => 'Usuario no autenticado',
                    'data' => null
                ])
                ->setStatusCode(401);
        }

        log_message('debug', '✅ AuthFilter - Usuario autenticado: ' . $usuario['username']);

        // Guardar el usuario en el request para usarlo en los controladores
        $request->usuario = $usuario;
        
        return $request;
    }

    public function after(RequestInterface $request, ResponseInterface $response, $arguments = null)
    {
        // No hacer nada después
    }
}
